# Łamanie prostego szyfru podstawieniowego, https://inventwithpython.com/hacking (na licencji BSD).
import pyperclip, simpleSubKeyword, detectEnglish

SILENT_MODE = False

def main():
    myMessage = r"""SJITDOPIQR: JIR RIQMUNQRO AY P WDQC QCR NRSMRQN JT A SJITDORO QJ CRMNRGT AY S. -PHAMJNR ADRMSR"""

    brokenCiphertext = hackSimpleSubDictionary(myMessage)

    if brokenCiphertext == None:
        # hackSimpleSubDictionary() zwróci wartość None, jeżeli nie udało się złamać szyfru.
        print('Deszyfrowanie zakończyło się niepowodzeniem. Nie udało się złamać szyfrogramu.')
    else:
        # Deszyfrowana wiadomość została wyświetlona na ekranie; dla wygody
        # użytkownika jej tekst został również skopiowany do schowka.
        print('Deszyfrowana wiadomość została skopiowana do schowka:')
        print(brokenCiphertext)
        pyperclip.copy(brokenCiphertext)


def hackSimpleSubDictionary(message):
    print('Łamanie szyfru za pomocą %s potencjalnych słów słownika...' % (len(detectEnglish.ENGLISH_WORDS) * 3))

    # Program Pythona można zatrzymać w dowolnym momencie przez naciśnięcie klawiszy Ctrl+C (Windows) lub Ctrl+D (macOS i Linux).
    print('(Naciśnij klawisze Ctrl+C lub Ctrl+D, aby w dowolnym momencie zakończyć działanie programu.)')

    tryNum = 1

    # Podejście typu brute-force, które w tym programie oznacza iterację przez wszystkie możliwe klucze.
    for key in detectEnglish.ENGLISH_WORDS:
        if tryNum % 100 == 0 and not SILENT_MODE:
            print('Sprawdzono klucz %s... (%s)' % (tryNum, key))

        decryptedText = simpleSubKeyword.decryptMessage(key, message)

        if detectEnglish.getEnglishCount(decryptedText) > 0.20:
            #  Użytkownik powinien potwierdzić, czy tekst został deszyfrowany prawidłowo.
            print()
            print('Potencjalnie udane złamanie szyfru:')
            print('Klucz: ' + str(key))
            print('Deszyfrowana wiadomość: ' + decryptedText[:100])
            print()
            print('Wpisz D, aby zakończyć. Dowolny inny klawisz kontynuuje hacking:')
            response = input('> ')

            if response.upper().startswith('D'):
                return decryptedText

        tryNum += 1
    return None

if __name__ == '__main__':
    main()
